import java.rmi.Naming;
import java.rmi.registry.Registry;

/**
 * Classe che si occupa di connettere il client al server, ritornando al client
 * un riferimento al server remoto.
 * La classe  stata realizzata, poich il cliente non  tenuto a sapere che ci
 * sono due livelli di registry e quale politica sia utilizzata per scegliere 
 * lo specifico servitore a cui sar legato il client.
 * La classe contiene un unico metodo statico che si occupa appunto della 
 * connnessione del client col server
 * 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class DoConnectionToServer {
	public static INewsgroupServer connect(int RMIPort,String hostName,String service)throws Exception{
		RegistryInfo reg= new RegistryInfo(RMIPort,hostName,service);
		ChooseServerRandom server=new ChooseServerRandom(reg);
		INewsgroupServer server_ref =null;
		int numServ=server.numServers();
		int numTry=0;
		
		//Ciclo che serve perch se un server remoto cade, il riferimento potrebbe essere nullo
		//ma potrebbero esserci altri server liberi ed attivi per il cliente
		do{
			String registryURL = "rmi://" +reg.getHost()+ ":" 
							+reg.getFirstLevelPortNumber()
							+"/"+reg.getServiceName();
		
			/* recupero riferimento al server */
			Registry regA =(Registry)Naming.lookup(registryURL);
			server_ref =(INewsgroupServer)regA.lookup(server.whichServer());
			numTry++;
		}while((server_ref==null)&&(numTry<(numServ/2+1)));
		return server_ref;
	}
}

